//
//  OPXPayloadKey.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2016-08-17.
//
//

#import <Foundation/Foundation.h>

FOUNDATION_EXTERN NSString * const OPXEncryptedPayloadAlgKey;
FOUNDATION_EXTERN NSString * const OPXEncryptedPayloadDataKey;

FOUNDATION_EXPORT NSString * const OPXPayloadDecryptionFailureDomain;
typedef NS_ENUM(NSUInteger, OPXPayloadDecryptionFailureCode) {
	OPXPayloadDecryptionFailureAlgorithmIncorrect = 0,
	OPXPayloadDecryptionFailureIllegalStructure = 1, // (e.g., no IV, hmac less than 12 bytes) This is checked _before_ any crypto
	OPXPayloadDecryptionFailureHMACIncorrect = 2,
	OPXPayloadDecryptionFailureOther = 3, // Not sayin
};

@protocol OPXPayloadKey <NSObject>

+ (NSString *)alg;
- (NSDictionary *)encryptPayload:(id)jsonPayload;
- (id)decryptPayload:(NSDictionary *)encryptedPayload error:(NSError **)error;

@end
